

*--------------------------------------------------;
*CAT01 Logic;
*Initialize CAT indicator to not triggered;
V0200A01A = '0';

*Trigger on Condition 1;
*Current assessment is limited to a non-admission comprehensive assessment;
IF (A0310A = '03' OR A0310A = '04' OR A0310A = '05')
THEN DO;

	*Check that C0500 and V0100D both have non-missing values (00 to 15); 
	IF (C0500 >= '00' AND C0500 <= '15') AND 
     		(V0100D >= '00' AND V0100D <= '15') 
	THEN DO;
		*Trigger Care Area if current assessment score < prior;
		*   assessment score;
		IF C0500 < V0100D THEN V0200A01A = '1';
	END;

END;

*Trigger on Condition 2;
IF C1600 = '1' THEN V0200A01A = '1';

*--------------------------------------------------;
*CAT02 Logic;
*Initialize CAT indicator to not triggered;
V0200A02A = '0';

*Trigger on Condition 1;
IF C0500 >= '00' AND C0500 < '13' THEN V0200A02A = '1';

*Trigger on Condition 2;
*Condition 2 applicable only if BIMS summary score is not available;
IF ((C0500 = '99') OR (SUBSTR(C0500,1,1) = '-') OR (SUBSTR(C0500,1,1) = '^')) 
AND (C0700 = '1') THEN V0200A02A = '1';

*Trigger on Condition 3;
*Condition 3 applicable only if BIMS summary score is not available;
IF ((C0500 = '99') OR (SUBSTR(C0500,1,1) = '-') OR (SUBSTR(C0500,1,1) = '^')) 
AND (C0800 = '1') THEN V0200A02A = '1';

*Trigger on Condition 4;
*Condition 4 applicable only if BIMS summary score is not available;
IF ((C0500 = '99') OR (SUBSTR(C0500,1,1) = '-') OR (SUBSTR(C0500,1,1) = '^')) AND 
((C1000 >= '1') AND (C1000 <= '3')) THEN V0200A02A = '1';

*Trigger on Condition 5;
IF ((C1300A = '1') OR (C1300A = '2')) OR 
((C1300B = '1') OR (C1300B = '2')) OR 
((C1300C = '1') OR (C1300C = '2')) OR 
((C1300D = '1') OR (C1300D = '2')) THEN V0200A02A = '1';

*Trigger on Condition 6;
IF ((E0200A >= '1' AND E0200A <= '3') OR
(E0200B >= '1' AND E0200B <= '3') OR 
(E0200C >= '1' AND E0200C <= '3')) THEN V0200A02A = '1';

*Trigger on Condition 7;
IF E0800 >= '1' AND E0800 <= '3' THEN V0200A02A = '1';

*Trigger on Condition 8;
IF E0900 >= '1' AND E0900 <= '3' THEN V0200A02A = '1';

*--------------------------------------------------;
*CAT03 Logic;
*Initialize CAT indicator to not triggered;
V0200A03A = '0';

*Trigger on Condition 1;
IF I6500 = '1' THEN V0200A03A = '1';

*Trigger on Condition 2;
IF B1000 >= '1' AND B1000 <= '4' THEN V0200A03A = '1';

*--------------------------------------------------;
*CAT04 Logic;
*Initialize CAT indicator to not triggered;
V0200A04A = '0';

*Trigger on Condition 1;
IF B0200 >= '1' AND B0200 <= '3' THEN V0200A04A = '1';

*Trigger on Condition 2;
IF B0700 >= '1' AND B0700 <= '3' THEN V0200A04A = '1';

*Trigger on Condition 3;
IF B0800 >= '1' AND B0800 <= '3' THEN V0200A04A = '1';

*--------------------------------------------------;
*CAT05 Logic;
*Initialize CAT indicator to not triggered;
V0200A05A = '0';

*Resident is considered if independent, modified independent or moderately;
*impaired regarding cognitive skills for daily decision making;
IF ((C1000 >= '0' AND C1000 <= '2') OR 
    (C0500 >= '05' AND C0500 <= '15')) 
THEN DO;

	*Trigger on Condition 1;
	IF (G0110A1 >= '1' AND G0110A1 <= '4')
	THEN V0200A05A = '1';

	*Trigger on Condition 2;
	IF (G0110B1 >= '1' AND G0110B1 <= '4')
	THEN V0200A05A = '1';

	*Trigger on Condition 3;
	IF (G0110C1 >= '1' AND G0110C1 <= '4')
	THEN V0200A05A = '1';

	*Trigger on Condition 4;
	IF (G0110D1 >= '1' AND G0110D1 <= '4')
	THEN V0200A05A = '1';

	*Trigger on Condition 5;
	IF (G0110E1 >= '1' AND G0110E1 <= '4')
	THEN V0200A05A = '1';

	*Trigger on Condition 6;
	IF (G0110F1 >= '1' AND G0110F1 <= '4')
	THEN V0200A05A = '1';

	*Trigger on Condition 7;
	IF (G0110G1 >= '1' AND G0110G1 <= '4')
	THEN V0200A05A = '1';

	*Trigger on Condition 8;
	IF (G0110H1 >= '1' AND G0110H1 <= '4')
	THEN V0200A05A = '1';

	*Trigger on Condition 9;
	IF (G0110I1 >= '1' AND G0110I1 <= '4')
	THEN V0200A05A = '1';

	*Trigger on Condition 10;
	IF (G0110J1 >= '1' AND G0110J1 <= '4')
	THEN V0200A05A = '1';

	*Trigger on Condition 11;
	IF G0120A >= '1' AND G0120A <= '4' THEN V0200A05A = '1';

	 *Trigger on Condition 12;
	IF (G0300A = '1' OR G0300A = '2') OR
	(G0300B = '1' OR G0300B = '2') OR
	(G0300C = '1' OR G0300C = '2') OR
	(G0300D = '1' OR G0300D = '2') OR
	(G0300E = '1' OR G0300E = '2') THEN V0200A05A = '1';

	*Trigger on Condition 13;
	IF G0900A = '1' THEN V0200A05A = '1'; 

	*Trigger on Condition 14;
	IF G0900B = '1' THEN V0200A05A = '1' ;

END;

*--------------------------------------------------;
*CAT06 Logic;
*Initialize CAT indicator to not triggered;
V0200A06A = '0';

*Trigger on Condition 1;
IF (G0110I1 >= '2' AND G0110I1 <= '4') 
THEN V0200A06A = '1';

*Trigger on Condition 2;
IF H0100A = '1' THEN V0200A06A = '1';

*Trigger on Condition 3;
IF H0100B = '1' THEN V0200A06A = '1';

*Trigger on Condition 4;
IF H0100D = '1' THEN V0200A06A = '1';

*Trigger on Condition 5;
IF H0300 >= '1' AND H0300 <= '3' THEN V0200A06A = '1';

*Trigger on Condition 6;
IF M1040H = '1' THEN V0200A06A = '1';

*--------------------------------------------------;
*CAT07 Logic;
*Initialize CAT indicator to not triggered;
V0200A07A = '0';

*Trigger on Condition 1;
IF D0200A1 = '1' THEN V0200A07A = '1';

*Trigger on Condition 2;
IF D0500A1 = '1' THEN V0200A07A = '1';

*Trigger on Condition 3;
IF F0500F = '3' OR F0500F = '4' THEN V0200A07A= '1';

*Trigger on Condition 4;
IF F0800Q = '0' THEN V0200A07A = '1';

*Trigger on Condition 5;
IF (E0200A >= '1' AND E0200A <= '3') AND
(I4800 = '0' OR I4800 = '-') AND
(I4200 = '0' OR I4200 = '-') THEN V0200A07A = '1';

*Trigger on Condition 6;
IF (E0200B >= '1' AND E0200B <= '3') AND
(I4800 = '0' OR I4800 = '-') AND
(I4200 = '0' OR I4200 = '-') THEN V0200A07A = '1';

*Trigger on Condition 7;
*Count number of F0500 items = 4;
n_f0500eq4 = 0;
IF F0500A = '4' THEN n_f0500eq4 = n_f0500eq4 + 1;
IF F0500B = '4' THEN n_f0500eq4 = n_f0500eq4 + 1;
IF F0500C = '4' THEN n_f0500eq4 = n_f0500eq4 + 1;
IF F0500D = '4' THEN n_f0500eq4 = n_f0500eq4 + 1;
IF F0500E = '4' THEN n_f0500eq4 = n_f0500eq4 + 1;
IF F0500F = '4' THEN n_f0500eq4 = n_f0500eq4 + 1;
IF F0500G = '4' THEN n_f0500eq4 = n_f0500eq4 + 1;
IF F0500H = '4' THEN n_f0500eq4 = n_f0500eq4 + 1;

IF (n_f0500eq4 >= 6) AND F0600 = '1' THEN V0200A07A = '1';

*--------------------------------------------------;
*CAT08 Logic;
*Initialize CAT indicator to not triggered;
V0200A08A = '0';

*Trigger on Condition 1;
IF D0200I1 = '1' THEN V0200A08A = '1';

*Trigger on Condition 2;
IF D0500I1 = '1' THEN V0200A08A = '1';

*Trigger on Condition 3;
*Current assessment is limited to a non-admission comprehensive assessment;
IF (A0310A = '03' OR A0310A = '04' OR A0310A = '05')
THEN DO;
 
	*Check that D0300 and V0100E both have non-missing values (00 to 27);
	IF (D0300 >= '00' AND D0300 <= '27') AND 
     		(V0100E >= '00' AND V0100E <= '27') 
	THEN DO;
		*Trigger CAT if current assessment score > prior; 
		*     assessment score;
		IF D0300 > V0100E THEN V0200A08A = '1';
	END;
END;

 *Trigger on Condition 4;
*Current assessment is limited to a non-admission comprehensive assessment,;
*   and the resident interview is not successfully completed;
IF (A0310A = '03' OR A0310A = '04' OR A0310A = '05') AND
     (D0300 < '00' OR D0300 > '27')
THEN DO;

	*Check that D0600 and V0100F both have non-missing values (00 to 30);
	IF (D0600 >= '00' AND D0600 <= '30') AND 
     		(V0100F >= '00' AND V0100F <= '30') 
	THEN DO;
		*Trigger CAT if current assessment score > prior;
		*assessment score;
		IF D0600 > V0100F THEN V0200A08A = '1';
	END;
END;

*Trigger on Condition 5;
IF D0300 >= '10' AND D0300 <= '27' THEN V0200A08A = '1';

*Trigger on Condition 6;
IF D0600 >= '10' AND D0600 <= '30' THEN V0200A08A = '1';

*--------------------------------------------------;
*CAT09 Logic;
*Initialize CAT indicator to not triggered;
V0200A09A = '0';

*Trigger on Condition 1;
IF E0800 >= '1' AND E0800 <= '3' THEN V0200A09A = '1';

*Trigger on Condition 2;
IF E0900 >= '1' AND E0900 <= '3' THEN V0200A09A = '1';

*Trigger on Condition 3;
IF E1100 = '2' THEN V0200A09A = '1';

*Trigger on Condition 4;
IF E0300 = '1' THEN V0200A09A = '1';

*--------------------------------------------------;
*CAT10 Logic;
*Initialize CAT indicator to not triggered;
V0200A10A = '0';

*Trigger on Condition 1;
IF D0200A1 = '1' THEN V0200A10A = '1';

*Trigger on Condition 2;
IF D0500A1 = '1' THEN V0200A10A = '1';

*Trigger on Condition 3;
*Count number of F0500 items = 4 or 5;
n_f0500eq45 = 0;
IF (F0500A = '4' OR F0500A = '5') THEN n_f0500eq45 = n_f0500eq45 + 1;
IF (F0500B = '4' OR F0500B = '5') THEN n_f0500eq45 = n_f0500eq45 + 1;
IF (F0500C = '4' OR F0500C = '5') THEN n_f0500eq45 = n_f0500eq45 + 1;
IF (F0500D = '4' OR F0500D = '5') THEN n_f0500eq45 = n_f0500eq45 + 1;
IF (F0500E = '4' OR F0500E = '5') THEN n_f0500eq45 = n_f0500eq45 + 1;
IF (F0500F = '4' OR F0500F = '5') THEN n_f0500eq45 = n_f0500eq45 + 1;
IF (F0500G = '4' OR F0500G = '5') THEN n_f0500eq45 = n_f0500eq45 + 1;
IF (F0500H = '4' OR F0500H = '5') THEN n_f0500eq45 = n_f0500eq45 + 1;

IF (n_f0500eq45 >= 6) THEN V0200A10A = '1';

*Trigger on Condition 4;
*Count number of F0800L through F0800T not checked;
n_f0800eq0 = 0;
IF F0800L = '0' THEN n_f0800eq0 = n_f0800eq0 + 1;
IF F0800M = '0' THEN n_f0800eq0 = n_f0800eq0 + 1;
IF F0800N = '0' THEN n_f0800eq0 = n_f0800eq0 + 1;
IF F0800O = '0' THEN n_f0800eq0 = n_f0800eq0 + 1;
IF F0800P = '0' THEN n_f0800eq0 = n_f0800eq0 + 1;
IF F0800Q = '0' THEN n_f0800eq0 = n_f0800eq0 + 1;
IF F0800R = '0' THEN n_f0800eq0 = n_f0800eq0 + 1;
IF F0800S = '0' THEN n_f0800eq0 = n_f0800eq0 + 1;
IF F0800T = '0' THEN n_f0800eq0 = n_f0800eq0 + 1;

IF (n_f0800eq0 >= 6) THEN V0200A10A = '1';

*--------------------------------------------------;
*CAT11 Logic;
*Initialize CAT indicator to not triggered;
V0200A11A = '0';

*Trigger on Condition 1;
IF E0900 >= '1' AND E0900 <= '3' THEN V0200A11A = '1';

*Trigger on Condition 2;
IF (G0300A = '1' OR G0300A = '2') OR
 (G0300B = '1' OR G0300B = '2') OR
(G0300C = '1' OR G0300C = '2') OR
(G0300D = '1' OR G0300D = '2') OR
(G0300E = '1' OR G0300E = '2') THEN V0200A11A = '1';

*Trigger on Condition 3;
IF (A0310A = '01' AND J1700A = '1') THEN V0200A11A = '1';

*Trigger on Condition 4;
IF (A0310A = '01' AND J1700B = '1') THEN V0200A11A = '1';

*Trigger on Condition 5;
IF J1800 = '1' THEN V0200A11A = '1';

*Trigger on Condition 6;
IF N0410B >= '1' AND N0410B <= '7' THEN V0200A11A = '1';

*Trigger on Condition 7;
IF N0410C >= '1' AND N0410C <= '7' THEN V0200A11A = '1';

*Trigger on Condition 8;
IF P0100B = '1' OR P0100B = '2' THEN V0200A11A = '1';

*Trigger on Condition 9;
IF P0100E = '1' OR P0100E = '2' THEN V0200A11A = '1';

*--------------------------------------------------;
*CAT12 Logic;
*Initialize CAT indicator to not triggered;
V0200A12A = '0';

*Trigger on Condition 1;
IF J1550C = '1' THEN V0200A12A = '1';

*Trigger on Condition 2;
*Set BMI to 20 (will not trigger) if K0200A or K0200B missing ;
*   else calculate actual value;
IF K0200A = '-' OR K0200A = '00' OR K0200B = '-' OR K0200B = '000' 
     THEN BMI = 20.0000;
ELSE
     BMI = (INPUT(K0200B, 3.) * 703) / (INPUT (K0200A, 2.)**2 );
*Trigger on BMIl;
IF BMI < 18.5000 OR BMI > 24.9000 THEN V0200A12A = '1';

*Trigger on Condition 3;
IF K0300 = '1' OR K0300 = '2' THEN V0200A12A = '1';

*Trigger on Condition 4;
IF K0310 = '1' OR K0310 = '2' THEN V0200A12A = '1';

*Trigger on Condition 5;
IF K0510A1 = '1' OR K0510A2 = '1' THEN V0200A12A = '1';

*Trigger on Condition 6;
IF K0510C1 = '1' OR K0510C2 = '1' THEN V0200A12A = '1';

*Trigger on Condition 7;
IF K0510D1 = '1' OR K0510D2 = '1' THEN V0200A12A = '1';

*Trigger on Condition 8;
IF ((M0300B1 > '0' AND M0300B1 <= '9') OR
    (M0300C1 > '0' AND M0300C1 <= '9') OR
    (M0300D1 > '0' AND M0300D1 <= '9') OR
    (M0300E1 > '0' AND M0300E1 <= '9') OR
    (M0300F1 > '0' AND M0300F1 <= '9') OR
    (M0300G1 > '0' AND M0300G1 <= '9'))
        THEN V0200A12A = '1';

*--------------------------------------------------;
*CAT13 Logic;
*Initialize CAT indicator to not triggered;
V0200A13A = '0';

*Trigger on Condition 1;
IF K0510B1 = '1' OR K0510B2 = '1' THEN V0200A13A = '1';

*--------------------------------------------------;
*CAT14 Logic;
*Initialize CAT indicator to not triggered;
V0200A14A = '0';

*Trigger on Condition 1;
IF J1550A = '1' THEN V0200A14A = '1';

*Trigger on Condition 2;
IF J1550B = '1' THEN V0200A14A = '1';

*Trigger on Condition 3;
IF J1550C = '1' THEN V0200A14A = '1';

*Trigger on Condition 4;
IF J1550D = '1' THEN V0200A14A = '1';

*Trigger on Condition 5;
IF 
(I1700 = '1') OR
(I2000 = '1') OR
(I2100 = '1') OR
(I2200 = '1') OR
(I2300 = '1') OR
(I2400 = '1') OR
(I2500 = '1') OR
((M1040A = '1')) 
THEN V0200A14A = '1';

*Trigger on Condition 6;
IF H0600 = '1' THEN V0200A14A = '1';

*Trigger on Condition 7;
IF K0510A1 = '1' OR K0510A2 = '1' THEN V0200A14A = '1';

*Trigger on Condition 8;
IF K0510B1 = '1' OR K0510B2 = '1' THEN V0200A14A = '1';

*--------------------------------------------------;
*CAT15 Logic;
*Initialize CAT indicator to not triggered;
V0200A15A = '0';

*Trigger on Condition 1;
IF (L0200A = '1') OR
(L0200B = '1') OR
(L0200C = '1') OR
(L0200D = '1') OR
(L0200E = '1') OR
(L0200F = '1') THEN V0200A15A = '1';

*--------------------------------------------------;
*CAT16 Logic;
*Initialize CAT indicator to not triggered;
V0200A16A = '0';

*Trigger on Condition 1;
IF (G0110A1 >= '1' AND G0110A1 <= '4') OR 
(G0110A1 = '7' OR G0110A1 = '8') 
THEN V0200A16A = '1';

*Trigger on Condition 2;
IF H0300 = '2' OR H0300 = '3' THEN V0200A16A = '1';

*Trigger on Condition 3;
IF H0400 = '2' OR H0400 = '3' THEN V0200A16A = '1';

*Trigger on Condition 4;
IF K0300 = '2' THEN V0200A16A = '1';

*Trigger on Condition 5;
IF M0150 = '1' THEN V0200A16A = '1';

*Trigger on Condition 6;
IF ((M0300B1 > '0' AND M0300B1 <= '9') OR
(M0300C1 > '0' AND M0300C1 <= '9' ) OR
(M0300D1 > '0' AND M0300D1 <= '9') OR
(M0300E1 > '0' AND M0300E1 <= '9') OR
(M0300F1 > '0' AND M0300F1 <= '9') OR
(M0300G1 > '0' AND M0300G1 <= '9'))
THEN V0200A16A = '1';

*Trigger on Condition 7;
IF M0300A > '0' AND M0300A <= '9'
THEN V0200A16A = '1';

*Trigger on Condition 8;
IF (M0800A > '0' AND M0800A <= '9') OR 
(M0800B > '0' AND M0800B <= '9') OR 
(M0800C > '0' AND M0800C <= '9') 
THEN V0200A16A = '1';

*Trigger on Condition 9;
IF P0100B = '1' OR P0100B = '2' THEN V0200A16A = '1';

*Trigger on Condition 10;
IF P0100E = '1' OR P0100E = '2' THEN V0200A16A = '1';

*--------------------------------------------------;
*CAT17 Logic;
*Initialize CAT indicator to not triggered;
V0200A17A = '0';

*Trigger on Condition 1;
IF N0410A >= '1' AND N0410A <= '7' THEN V0200A17A = '1';

*Trigger on Condition 2;
IF N0410B >= '1' AND N0410B <= '7' THEN V0200A17A = '1';

*Trigger on Condition 3;
IF N0410C >= '1' AND N0410C <= '7' THEN V0200A17A = '1';

*Trigger on Condition 4;
IF N0410D >= '1' AND N0410D <= '7' THEN V0200A17A = '1';

*--------------------------------------------------;
*CAT18 Logic;
*Initialize CAT indicator to not triggered;
V0200A18A = '0';

*Trigger on Condition 1;
IF P0100A = '1' OR P0100A = '2' THEN V0200A18A = '1';

*Trigger on Condition 2;
IF P0100B = '1' OR P0100B = '2' THEN V0200A18A = '1';

*Trigger on Condition 3;
IF P0100C = '1' OR P0100C = '2' THEN V0200A18A = '1';

*Trigger on Condition 4;
IF P0100D = '1' OR P0100D = '2' THEN V0200A18A = '1';

*Trigger on Condition 5;
IF P0100E = '1' OR P0100E = '2' THEN V0200A18A = '1';

*Trigger on Condition 6;
IF P0100F = '1' OR P0100F = '2' THEN V0200A18A = '1';

*Trigger on Condition 7;
IF P0100G = '1' OR P0100G = '2' THEN V0200A18A = '1';

*Trigger on Condition 8;
IF P0100H = '1' OR P0100H = '2' THEN V0200A18A = '1';

*--------------------------------------------------;
*CAT19 Logic;
*Initialize CAT indicator to not triggered;
V0200A19A = '0';

*Trigger on Condition 1;
IF J0500A = '1' THEN V0200A19A = '1';

*Trigger on Condition 2;
IF J0500B = '1' THEN V0200A19A = '1';

*Trigger on Condition 3;
IF J0600A >= '07' AND J0600A <= '10' THEN V0200A19A = '1';

*Trigger on Condition 4;
IF J0600B = '3' OR J0600B = '4' THEN V0200A19A = '1';

*Trigger on Condition 5;
IF (J0400 = '1' OR J0400 = '2') AND
 ((J0600A >= '04' AND J0600A <= '10') OR 
(J0600B >= '2' AND J0600B <= '4')) 
THEN V0200A19A = '1';

*Trigger on Condition 6;
IF (J0800A = '1') OR (J0800B = '1') OR 
(J0800C = '1') OR (J0800D = '1') 
THEN V0200A19A = '1';

*--------------------------------------------------;
*CAT20 Logic;
*Initialize CAT indicator to not triggered;
V0200A20A = '0';

*Trigger on Condition 1;
IF Q0600 = '1'
     THEN V0200A20A = '1';

